class Proj_Tower_Nali extends Projectile;

var bool bExploded, bExplosionEffect, bHitPawn;
var() texture ExpType;
var() Sound EffectSound1;
var() texture SpriteAnim[20];
var() int NumFrames;
var Float AnimTime;

event ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.IsA('NoPlayerZone') )
		Self.Destroy();
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	SetTimer(0.8, true);
	if ( Level.NetMode == NM_Client )
		LifeSpan = 2.0;
	else
		Velocity = Speed * vector(Rotation);
	if ( Level.bDropDetail )
		LightType = LT_None;
}

simulated function Timer()
{
	if ( Level.bDropDetail )
		LightType = LT_None;
	if ( (Physics == PHYS_None) && (LifeSpan > 0.5) )
		LifeSpan = 0.5;
}

simulated function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
{
	//bExploded = True;
}

function BlowUp(vector HitLocation)
{
	PlaySound(EffectSound1,,7.0);	
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	if ( !bExplosionEffect )
	{
		if ( Role == ROLE_Authority )
			BlowUp(HitLocation);
		bExplosionEffect = true;
		if ( !Level.bHighDetailMode || bHitPawn || Level.bDropDetail )
		{
			if ( bExploded )
			{
				Destroy();
				return;
			}
			else
				DrawScale = 0.45;
		}
		else
			DrawScale = 0.65;

	    LightType = LT_Steady;
		LightRadius = 5;
		SetCollision(false,false,false);
		LifeSpan = 0.5;
		Texture = ExpType;
		DrawType = DT_SpriteAnimOnce;
		Style = STY_Translucent;
		if ( Region.Zone.bMoveProjectiles && (Region.Zone.ZoneVelocity != vect(0,0,0)) )
		{
			bBounce = true;
			Velocity = Region.Zone.ZoneVelocity;
		}
		else
			SetPhysics(PHYS_None);
	}
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
local Inv_GotFrozen GF;

	If ( Other.IsA('Balloon') || Other == Level )
		{
		bHitPawn = true;
		bExploded = !Level.bHighDetailMode || Level.bDropDetail;
		Other.TakeDamage( 2, instigator, HitLocation, MomentumTransfer*Vector(Rotation), 'Tower');	
		Explode(HitLocation, vect(0,0,1));
		if ( !Other.IsA('Balloon_zeppelin') && !Other.IsA('Balloon_big_red') && !Other.IsA('Balloon_big_blue') && !Other.IsA('Balloon_big_green') && !Other.IsA('Balloon_big_yellow') )
			{
			GF  = Spawn(Class'Inv_GotFrozen', Pawn(Other), 'Inv_GotFrozen' , Other.location, Other.Rotation);
			if ( GF != None )
				{
				GF.BecomePickup();
				GF.bHeldItem = True;
				GF.RespawnTime = 0.0;
				GF.GiveTo(Pawn(Other));
				GF.InstigatedBy = Instigator;
				GF.Activate();
				}
			}
		}
}

auto State Flying
{
Begin:
	LifeSpan = 2.0;
}

defaultproperties
{
     ExpType=Texture'Botpack.ShockExplo.asmdex_a00'
     EffectSound1=Sound'UnrealShare.Generic.LavaEn'
     NumFrames=11
     speed=1450.000000
     Damage=20.000000
     MomentumTransfer=10000
     MyDamageType=Pulsed
     ExploWallOut=10.000000
     ExplosionDecal=Class'Botpack.BoltScorch'
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.500000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'Botpack.ASMDAlt.ASMDAlt_a00'
     DrawScale=0.190000
     AmbientGlow=187
     bUnlit=True
     SoundRadius=10
     SoundVolume=218
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=83
     LightRadius=3
     bFixedRotationDir=True
}
